/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.lang.reflect.Constructor;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.SimpleStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;

public class BlockObjectStore
extends SimpleStore {
    final Class objectClass;
    final Constructor constructor;
    final int storageSize;
    final int blockSize;

    public BlockObjectStore(DataFileCache dataFileCache, TableSpaceManager tableSpaceManager, Class<?> clazz, int n, int n2) {
        this.cache = dataFileCache;
        this.spaceManager = tableSpaceManager;
        this.objectClass = clazz;
        this.blockSize = n2;
        this.storageSize = n;
        try {
            this.constructor = clazz.getConstructor(Integer.TYPE);
        }
        catch (Exception exception) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
    }

    @Override
    public CachedObject get(long l) {
        return this.cache.get(l, this.storageSize, this, false);
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        return this.cache.get(cachedObject.getPos(), this.storageSize, this, bl);
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        return this.cache.get(l, this.storageSize, this, bl);
    }

    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        throw Error.runtimeError(201, "BlockObjectStore");
    }

    @Override
    public void add(CachedObject cachedObject, boolean bl) {
        int n = cachedObject.getRealSize(this.cache.rowOut);
        if (n > this.storageSize) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
        cachedObject.setStorageSize(this.storageSize);
        long l = this.spaceManager.getFilePosition(this.storageSize, true);
        cachedObject.setPos(l);
        this.cache.add(cachedObject, bl);
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        CachedObject cachedObject = this.getNewInstance();
        cachedObject.read(rowInputInterface);
        int n = cachedObject.getRealSize(this.cache.rowOut);
        if (n > this.storageSize) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
        cachedObject.setStorageSize(this.storageSize);
        return cachedObject;
    }

    @Override
    public CachedObject getNewInstance(int n) {
        throw Error.runtimeError(201, "BlockObjectStore");
    }

    private CachedObject getNewInstance() {
        try {
            CachedObject cachedObject = (CachedObject)this.constructor.newInstance(this.blockSize);
            return cachedObject;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

