/*
 * Decompiled with CFR 0.152.
 */
package datahelper;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class DataHelper {
    public static void main(String[] args) throws Exception {
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        String sCon = "jdbc:sqlserver://aws.database;databaseName=AlexisPTSTest;user=gpspl;password=yW2S6KXdY8";
        Connection sqlConnection = DriverManager.getConnection(sCon);
        Class.forName("org.postgresql.Driver");
        Connection sqliteConnection = DriverManager.getConnection("jdbc:postgresql://localhost/test?user=paul&password=pass");
        String sourceSQL = "EXEC [Clearing].[GetUnclearedAuthorisations]";
        String targetTable = "tmpUnclearedAuthorisations";
        int iRows = DataHelper.CopyData(sqlConnection, sqliteConnection, sourceSQL, targetTable, true);
        System.out.println(iRows);
    }

    public static int CopyData(Connection soureCon, Connection targetCon, String sourceSql, String targetTable, boolean dropTargetTable) throws Exception {
        int iRow = 0;
        int iBuffer = 50000;
        Statement sourceCommand = soureCon.createStatement();
        ResultSet dataReader = sourceCommand.executeQuery(sourceSql);
        ResultSetMetaData schemaTable = dataReader.getMetaData();
        targetCon.setAutoCommit(false);
        DataHelper.CreateTable(targetCon, schemaTable, targetTable, dropTargetTable);
        PreparedStatement targetCommand = DataHelper.PrepareCommand(targetCon, schemaTable, targetTable);
        while (dataReader.next()) {
            DataHelper.SetParams(dataReader, schemaTable, targetCommand);
            targetCommand.addBatch();
            if (++iRow % iBuffer != 0) continue;
            targetCommand.executeBatch();
            targetCon.commit();
        }
        if (iRow % iBuffer != 0) {
            targetCommand.executeBatch();
            targetCon.commit();
        }
        return iRow;
    }

    private static void CreateTable(Connection dbConnection, ResultSetMetaData schemaTable, String tableName, boolean withDrop) throws Exception {
        String dbTypeName = dbConnection.getMetaData().getDriverName();
        System.out.println(dbTypeName);
        if (withDrop) {
            dbConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s", tableName));
            dbConnection.commit();
        }
        String createNotExists = dbTypeName.contains("SQL Server") ? String.format("IF NOT EXISTS(SELECT 1 FROM sys.tables where name = '%s') CREATE TABLE", tableName) : "CREATE TABLE IF NOT EXISTS";
        StringBuilder Sql = new StringBuilder(String.format("%s %s (", createNotExists, tableName));
        int iColumns = schemaTable.getColumnCount();
        for (int i = 1; i < iColumns + 1; ++i) {
            if (i > 1) {
                Sql.append(", ");
            }
            String name = schemaTable.getColumnName(i);
            String dt = schemaTable.getColumnTypeName(i);
            int size = schemaTable.getPrecision(i);
            boolean nullable = schemaTable.isNullable(i) == 1;
            Sql.append(String.format("%s %s", name, dt));
            if (dt.toLowerCase().endsWith("char")) {
                Sql.append(String.format("(%d)", size));
            }
            if (nullable) continue;
            Sql.append(" NOT NULL");
        }
        Sql.append(")");
        String sqlString = Sql.toString();
        if (dbTypeName.contains("PostgreSQL")) {
            sqlString = sqlString.replaceAll("datetime", "timestamp");
            sqlString = sqlString.replaceAll("tinyint", "int");
            sqlString = sqlString.replaceAll("bit", "bool");
        }
        Statement createCommand = dbConnection.createStatement();
        createCommand.execute(sqlString);
        dbConnection.commit();
    }

    private static PreparedStatement PrepareCommand(Connection dbConnection, ResultSetMetaData schemaTable, String tableName) throws Exception {
        StringBuilder sbFields = new StringBuilder();
        StringBuilder sbFmtValues = new StringBuilder();
        int iColumns = schemaTable.getColumnCount();
        for (int i = 1; i < iColumns + 1; ++i) {
            String columnName = schemaTable.getColumnName(i);
            sbFields.append(i > 1 ? ", " : "");
            sbFields.append(columnName);
            sbFmtValues.append(i > 1 ? ", " : "");
            sbFmtValues.append("?");
        }
        String insertSql = String.format("INSERT INTO %s  (%s) VALUES (%s)", tableName, sbFields.toString(), sbFmtValues.toString());
        System.out.println(insertSql);
        PreparedStatement cmd = dbConnection.prepareStatement(insertSql);
        return cmd;
    }

    private static void SetParams(ResultSet dr, ResultSetMetaData schemaTable, PreparedStatement cmd) throws Exception {
        int iColumns = schemaTable.getColumnCount();
        for (int i = 1; i < iColumns + 1; ++i) {
            cmd.setObject(i, dr.getObject(i));
        }
    }
}

